<?php 
    $answer = 'Halo. Ada yang bisa saya bantu?';

    if(isset($_POST['submit'])) {
        $answer = $_POST['say']; 
    }
?>

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Chatbot with Voice Answer</title>
        <script type="text/javascript" src="js/jquery-2.js"></script>
        <script>
            var windowReady = false;
            var voiceReady = false;

            var defaultparams = 
            {
                rate: 1,
                pitch: 1,
                volume: 1,
                text: 'Terima Kasih',
                voice: 'Indonesian Female'
            };

            $(window).load( function() 
            {
                windowReady = true;
                $('#voiceselection').hide();
	            $('#text').show();
                $('#waitingdiv').show();
                responsiveVoice.speak('<?php echo $answer; ?>',$('#voiceselection').val());
                
                responsiveVoice.AddEventListener("OnLoad",function()
                {
                    console.log("ResponsiveVoice Loaded Callback") ;
                });

                CheckLoading();
            });

            responsiveVoice.OnVoiceReady = function() 
            {
                voiceReady = true;
                CheckLoading();
            }

            function CheckLoading() 
            {
                if (voiceReady && windowReady) 
                {
                    $('#voicetestdiv').fadeIn(0.5);
                    $('#waitingdiv').fadeOut(0.5);
                    var voicelist = responsiveVoice.getVoices();
                    var vselect = $("#voiceselection");
                    vselect.html("");
                    $.each(voicelist, function() 
                    {
                        vselect.append($("<option />").val(this.name).text(this.name));
                    });	      
                    $('#voiceselection').val(getUrlParameter('voice') || defaultparams.voice);
                }
            }

            var getUrlParameter = function getUrlParameter(sParam) 
            {
                var sPageURL = decodeURIComponent(window.location.search.substring(1)),
                sURLVariables = sPageURL.split('&'),
                sParameterName,
                i;

                for (i = 0; i < sURLVariables.length; i++) 
                {
                    sParameterName = sURLVariables[i].split('=');
                    if(sParameterName[0] === sParam) 
                    {
                        return sParameterName[1] === undefined ? true : sParameterName[1];
                    }
                }
            };

            function getUrlVars()
            {
                var vars = [], hash;
                var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
                for(var i = 0; i < hashes.length; i++)
                {
                    hash = hashes[i].split('=');
                    vars.push(hash[0]);
                    vars[hash[0]] = hash[1];
                }
                return vars;
            }

        </script>

    </head>

    <body>
       <script src="https://code.responsivevoice.org/responsivevoice.js?key=1ttJOexv"></script>

        <br>
        <label>Tuliskan percakapan:</label>
    
        <form method="POST" action=''>
            <input type='text' name='say' autofocus><br>
            <input type='submit' value='Kirim' name='submit' class='button'> 
        </form>
        <p>
            <?php 
                echo $answer; 
            ?>
        </p>
    
        <div class="inline">
            <div style="display: none;" id="waitingdiv">
                Memproses Jawaban.....<br>
            </div>
       
            <select id="voiceselection" style="display: none;">
                <option selected="selected" value="Indonesian Male">Indonesian Male</option>
            </select>

            <div style="display: block;" id="counterBox1" class="counterBox">
			
			    <input id="playbutton" value="Panggil" type="hidden">
			
                <input id="stopbutton" value="Berhenti" type="hidden"><br>
            </div>
        </div>
    
    </body>
</html>